"""AdvData class."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules
from typing_extensions import override

# 3. Aquaveo modules

# 4. Local modules
from xms.mf6.data.base_file_data import BaseFileData
from xms.mf6.data.options_block import OptionsBlock
from xms.mf6.gui.options_defs import CheckboxComboBox, CheckboxField


class AdvData(BaseFileData):
    """Data class to hold the info from a ADV package file."""
    def __init__(self, **kwargs):
        """Initializes the class.

        Args:
            **kwargs: Arbitrary keyword arguments.

        Keyword Args:
            ftype (str): The file type used in the GWF name file (e.g. 'WEL6')
            mfsim (MfsimData): The simulation.
            model (GwfData or GwtData): The GWF/GWT model. Will be None for TDIS, IMS, Exchanges (things below mfsim)
            grid_info (GridInfo): Information about the grid. Only used when testing individual packages. Otherwise,
             it comes from model and dis
        """
        super().__init__(**kwargs)
        self.ftype = 'ADV6'

    def dialog_title(self):
        """Returns the title to show in the dialog.

        Returns:
            (str): The dialog title.
        """
        return 'Advection (ADV) Package'

    @override
    def _setup_options(self) -> OptionsBlock:
        """Returns the definition of all the available options.

        Returns:
            See description.
        """
        return OptionsBlock(
            [
                CheckboxComboBox(
                    'SCHEME',
                    brief='Scheme used to solve the advection term',
                    items=['upstream', 'central', 'TVD'],
                    value='upstream'
                ),
                CheckboxField(
                    'ATS_PERCEL',
                    brief='Fractional cell distance submitted to the adaptive time stepping ATS package',
                    type_='float',
                    value=0.0
                ),
            ]
        )
