"""DisvReader class."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.mf6.data.grid_info import DisEnum
from xms.mf6.file_io.dis_reader_base import DisReaderBase


class DisvReader(DisReaderBase):
    """Reads a DISV package file."""
    def __init__(self):
        """Initializes the class."""
        super().__init__(ftype='DISV6')
        self._block_methods.update({'CELL2D': '_read_cell2d'})

    def _read_dimensions(self, line):
        """Reads the dimensions block.

        Args:
            line (str): A line from the file.
        """
        self._data.grid_info().dis_enum = DisEnum.DISV

        words = line.split()
        if words and len(words) > 1:
            if words[0].upper() == 'NLAY':
                self._data.grid_info().nlay = int(words[1])
            elif words[0].upper() == 'NCPL':
                self._data.grid_info().ncpl = int(words[1])
            elif words[0].upper() == 'NVERT':
                self._data.grid_info().nvert = int(words[1])

    def _read_cell2d(self, line):
        """Reads the CELL2D block.

        Args:
            line (str): A line from the file.

        Returns:
            True
        """
        rv = self._handle_list_block(line)
        return rv
