"""TableTextColorDelegate class."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules
from PySide2.QtGui import QColor, QPalette
from PySide2.QtWidgets import QStyledItemDelegate, QWidget
from typing_extensions import override

# 3. Aquaveo modules

# 4. Local modules


class TableTextRangeColorDelegate(QStyledItemDelegate):
    """Delegate to make text a different color in a table if it is outside the range."""
    def __init__(self, parent: QWidget, model, mn, mx, color: QColor | None = None):
        """Initializer.

        Args:
            parent: The parent widget.
            model: The model.
            mn: Minimum value for column.
            mx: Maximum value for column.
            color: The text color if the value is outside the range.
        """
        super().__init__(parent)
        self._model = model
        self._min = mn
        self._max = mx
        self._color = color if color is not None else QColor(255, 0, 0)

    @override
    def initStyleOption(self, option, index):
        """Initializes the style option.

        Args:
            option: The option.
            index: The index.
        """
        super().initStyleOption(option, index)

        # Get value and see if it's inside the range
        try:
            data = int(self._model.data(index))
            if not self._min <= data <= self._max:
                option.palette.setBrush(QPalette.Text, self._color)
        except TypeError:
            pass
