"""GweGweDialog class."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules
from PySide2.QtCore import Qt

# 3. Aquaveo modules

# 4. Local modules
from xms.mf6.gui import list_dialog
from xms.mf6.gui.exchanges.gwx_gwx_dialog_base import GwxGwxDialogBase


class GweGweDialog(GwxGwxDialogBase):
    """A dialog used for the GWE-GWE exchange."""
    def __init__(self, dlg_input, parent=None):
        """Initializes the class, sets up the ui, and loads the package.

        Args:
            dlg_input (DialogInput): Information needed by the dialog.
            parent (Something derived from QWidget): The parent window.
        """
        super().__init__(dlg_input, parent)

    def on_btn_mve6_filein(self):
        """Called when a FILEIN button is clicked."""
        list_dialog.run_list_dialog_for_filein('MVE6', self, self.options_gui.options_block)

    def on_chk_boundnames(self, checked):
        """Warns user that this will add or remove the boundname column and lets them cancel.

        Args:
            checked (bool): True if checkbox is checked.
        """
        if not self.loaded:
            return
        use_aux = 'chk_auxiliary' in self.options_gui.uix and self.options_gui.uix['chk_auxiliary'].isChecked()
        self.sp_widget.change_boundnames(checked == Qt.Checked, use_aux=use_aux)
