"""Canal monitor data."""
__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules

MONITOR_CSV = 'csv'
MONITOR_DSS = 'dss'
MONITOR_ASCII = 'asciiform'


def add_output_to_group(gp):
    """Add output to group.

    Args:
        gp (Group): group to add output to
    """
    gp.add_text(name='label', label='Monitor label (<label>)')

    options = [MONITOR_CSV, MONITOR_DSS, MONITOR_ASCII]
    opt_par = gp.add_option(name='output_type', label='Output type', default=MONITOR_DSS, options=options)
    gp.add_text(name='out_file', label='Output file name (<file>)')

    csv_flags = {opt: False for opt in options}
    csv_flags[MONITOR_CSV] = True
    p = gp.add_text(name='csv_label', label='Description of the output data (<label>)')
    p.add_dependency(parent=opt_par, flags=csv_flags)

    dbintl_flags = {opt: False for opt in options}
    dbintl_flags[MONITOR_CSV] = True
    dbintl_flags[MONITOR_DSS] = True
    label = 'Interval in minutes to save output (<dbintl>)'
    p = gp.add_integer(name='dbintl', label=label, default=0, low=0)
    p.add_dependency(parent=opt_par, flags=dbintl_flags)

    dss_path_flags = {opt: False for opt in options}
    dss_path_flags[MONITOR_DSS] = True
    p = gp.add_text(name='dss_path', label='DSS path')
    p.add_dependency(parent=opt_par, flags=dss_path_flags)

    ascii_format_flags = {opt: False for opt in options}
    ascii_format_flags[MONITOR_ASCII] = True
    p = gp.add_text(name='ascii_format', label='ASCII format of the output data <format>')
    p.add_dependency(parent=opt_par, flags=ascii_format_flags)
