"""Class for writing canal coverage data to model input files."""
__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.rsm.file_io.monitor_writer import MonitorWriter


class CanalMonitorWriter(MonitorWriter):
    """Writer class for the RSM control file."""
    def __init__(self, xml_parent, monitor_data):
        """Constructor.

        Args:
            xml_parent (xml.etree.cElementTree): xml parent element
            monitor_data (list): list of monitor data to write
        """
        super().__init__(xml_parent, [])
        self._monitor_xml_name = 'segmentmonitor'
        self._monitor_to_write = monitor_data
        self._feature_type = 'arc'

    def write(self):
        """Write the canal monitor data to the xml."""
        self._write_all_monitor()
