"""Class for waterbody data used when writing model input files."""
__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules


class WaterBodyInfo:
    """Class to hold information about a water body."""
    def __init__(self, label='', wb_id=-1, geometry=None):
        """Constructor.

        Args:
            label (str): The label of the water body.
            wb_id (int): The ID of the water body.
            geometry (shapely.geometry): The geometry of the water body, shapely LineString or Polygon.
        """
        self.label = label
        self.wb_id = wb_id
        self.geometry = geometry


class WaterBodyInfoJunction(WaterBodyInfo):
    """Class to hold information about a water body junction."""
    def __init__(self, label='', wb_id=-1, geometry=None, canal_ids=None):
        """Constructor.

        Args:
            label (str): The label of the water body junction.
            wb_id (int): The ID of the water body junction.
            geometry (shapely.geometry): The geometry of the water body junction, shapely Point.
            canal_ids (list): A list of adjacent canal IDs.
        """
        super().__init__(label, wb_id, geometry)
        self.canal_ids = canal_ids if canal_ids is not None else []
