"""Class for data used when writing model input files."""
__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.rsm.file_io import util


class WriterData:
    """Writer class for the RSM control file."""
    def __init__(self, xms_data=None, csv_writer=None, xml_mesh=None, xml_hse=None):
        """Constructor.

        Args:
            xms_data (XmsData, optional): Simulation data retrieved from SMS.
            csv_writer (CsvWriter, optional): CSV writer instance.
            xml_mesh (xml.etree.cElementTree.Element): mesh item in the xml
            xml_hse (xml.etree.cElementTree.Element): hse item in the xml
        """
        self.xms_data = xms_data
        self.csv_writer = csv_writer
        self.xml_mesh = xml_mesh
        self.xml_hse = xml_hse
        self.rule_curve_label_id = {}
        self.logger = util.get_logger()

        # [TYPE]: WaterBodyInfo
        # TYPE is one of 'canal', 'lake', 'basin', 'impoundment', 'wcdwaterbody'
        self.water_body_info = {
            'canal': [],
            'canal_junction': [],
            'lake': [],
            'basin': [],
            'impoundment': [],
            'wcd waterbody': [],
        }
