"""Module for the UpwindSolverCoverageComponent."""

__copyright__ = "(C) Copyright Aquaveo 2024"
__license__ = "All rights reserved"
__all__ = ['UpwindSolverCoverageComponent']

# 1. Standard Python modules
from pathlib import Path

# 2. Third party modules

# 3. Aquaveo modules
from xms.gmi.data.generic_model import GenericModel, Section
from xms.guipy.data.target_type import TargetType

# 4. Local modules
from xms.schism.components.coverage_component import CoverageComponent
from xms.schism.data.model import get_model


class UpwindSolverCoverageComponent(CoverageComponent):
    """Component for the upwind solver coverage."""
    def __init__(self, path: str | Path):
        """
        Initialize the component.

        Args:
            path: Path to the component's mainfile.
        """
        super().__init__(path)
        self.point_commands = self.arc_commands = []

    def _section(self, target_type: TargetType) -> Section:
        """
        Get a section from the coverage's model based on its `TargetType`.

        Args:
            target_type: `TargetType` for the desired section.

        Returns:
            The section for the feature type.
        """
        model = get_model()

        if target_type == TargetType.polygon:
            return model.material_parameters

        model = GenericModel()
        return model.section_from_target_type(target_type)
