"""BcDataArcs class."""

__copyright__ = "(C) Copyright Aquaveo 2019"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules
import param

# 3. Aquaveo modules
from xms.guipy.param.param_enabler import ParamEnabler  # noqa: I202

# 4. Local modules


class BcDataBcData(param.Parameterized):
    """Data for a BCDATA bc type."""
    label = param.String(
        label='Label (the label must be unique in the coverage)',
        default='',
        doc='Label for the BCDATA line.',
        precedence=1,
    )

    def __init__(self):
        """Initializes the class."""
        super().__init__()
        self.doing_update = False
        self.enabler = ParamEnabler(
            param_cls=self,
            enablers=[],
            depends={},
        )
