"""BcDataInletScWse class."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules
import pandas as pd
import param

# 3. Aquaveo modules

# 4. Local modules
from xms.guipy.param.param_enabler import ParamEnabler  # noqa: I202


class BcDataInletScWse(param.Parameterized):
    """Bc type inlet-sc-wse data."""
    water_elevation_option = param.ObjectSelector(
        label='Water elevation (WSE) option',
        default='Time series',
        objects=['Time series', 'Rating curve'],
        doc='time series selection type',
        precedence=1,
    )
    time_series_wse = param.DataFrame(
        default=pd.DataFrame(columns=['hrs', 'elev']),
        doc='time series for wse',
        precedence=2,
    )
    time_series_wse_units = param.String(
        label='',
        default='hrs -vs- ft',
        doc='units for time series WSE',
        precedence=3,
    )
    rating_curve = param.DataFrame(
        default=pd.DataFrame(columns=['vol_per_sec', 'WSE']),
        doc='time series for rating curve',
        precedence=4,
    )
    rating_curve_units = param.String(
        label='',
        default='cfs -vs- feet',
        doc='units for the rating curve',
        precedence=5,
    )

    def __init__(self):
        """Initializes the class."""
        super().__init__()
        self.enabler = ParamEnabler(
            param_cls=self,
            enablers=['water_elevation_option'],
            depends={
                'Time series': ['time_series_wse', 'time_series_wse_units'],
                'Rating curve': ['rating_curve', 'rating_curve_units'],
            },
        )

    @param.depends('water_elevation_option', watch=True)
    def _update_water_elevation_option(self):
        """Watches changes made to the discharge_option object."""
        self.enabler.do_enabling(force_disable=False)
