"""BcDataArcs class."""

__copyright__ = "(C) Copyright Aquaveo 2019"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules
import param

# 3. Aquaveo modules
from xms.guipy.param.param_enabler import ParamEnabler  # noqa: I202

# 4. Local modules


class BcDataLineSelector(param.Parameterized):
    """Data for selection of upstream and downstream BCDATA line for structures."""
    specify_upstream_bcdata_line = param.Boolean(
        label='Specify upstream BCDATA line',
        default=False,
        doc='Enables selection of an upstream BCDATA line for the wse of a structure.',
        precedence=1,
    )
    upstream_line_label = param.String(
        default='NONE',
        doc='Label from the BCDATA line.',
        precedence=-2,
    )
    upstream_line = param.ObjectSelector(
        default='NONE',
        objects=['NONE'],
        doc='Picker to allow user to select the bc data line.',
        precedence=3,
    )

    specify_downstream_bcdata_line = param.Boolean(
        label='Specify downstream BCDATA line',
        default=False,
        doc='Enables selection of an downstream BCDATA line for the wse of a structure.',
        precedence=4,
    )
    downstream_line_label = param.String(
        default='NONE',
        doc='Label from the BCDATA line.',
        precedence=-5,
    )
    downstream_line = param.ObjectSelector(
        default='NONE',
        objects=['NONE'],
        doc='Picker to allow user to select the bc data line.',
        precedence=6,
    )

    def __init__(self):
        """Initializes the class."""
        super().__init__()
        self.doing_update = False
        self.enabler = ParamEnabler(
            param_cls=self,
            enablers=['specify_upstream_bcdata_line', 'specify_downstream_bcdata_line'],
            depends={
                'specify_upstream_bcdata_line': ['upstream_line'],
                'specify_downstream_bcdata_line': ['downstream_line'],
            },
        )

    @param.depends('specify_upstream_bcdata_line', watch=True)
    def _update_specify_upstream_bcdata_line(self):
        """Watches changes made to the specify_upstream_bcdata_line object."""
        self.enabler.do_enabling(force_disable=False)

    @param.depends('specify_downstream_bcdata_line', watch=True)
    def _update_specify_downstream_bcdata_line(self):
        """Watches changes made to the specify_downstream_bcdata_line object."""
        self.enabler.do_enabling(force_disable=False)

    @param.depends('upstream_line', watch=True)
    def _update_upstream_line(self):
        """Watches changes made to the upstream_line object."""
        self.upstream_line_label = self.upstream_line

    @param.depends('downstream_line', watch=True)
    def _update_downstream_line(self):
        """Watches changes made to the downstream_line object."""
        self.downstream_line_label = self.downstream_line
