"""Script to launch srh post."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules

if __name__ == '__main__':
    import argparse
    from contextlib import redirect_stdout
    from xms.api.dmi import XmsEnvironment as XmEnv
    from xms.srh.model.srh_post_runner import run_post_process

    parser = argparse.ArgumentParser(description="SRH post.")
    parser.add_argument('-j', '--json-file', help='Path to srh_post.json', required=False, default='')
    args = parser.parse_args()

    log_file = XmEnv.xms_environ_stdout_file()
    with open(log_file, 'a') as stdout:
        with redirect_stdout(stdout):
            if args.json_file:
                run_post_process(args.json_file)
            else:
                run_post_process()
