"""Module for the RunSwmm class."""

__copyright__ = "(C) Copyright Aquaveo 2024"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules
from xms.api.dmi import ExecutableCommand, Query
from xms.components.bases.run_base import RunBase
from xms.data_objects.parameters import Simulation

# 4. Local modules
from xms.swmm.xml_entry_points import swmm_run as swmm_runner


class RunSwmm(RunBase):
    """Class that finds runs SWMM."""

    def __init__(self):
        """Initializes the class."""
        super().__init__()

    def get_executables(self, do_sim: Simulation, query: Query, file_location) -> list[ExecutableCommand]:
        """
        Get the executable commands for any Simulation object given.

        Args:
            do_sim: The Simulation you want to load the solution for.
            query: Inter-process communication object.
            file_location: The location of input files for the simulation.

        Returns:
            The executable objects to run and the action requests that go with it.
        """
        cmd = ExecutableCommand(
            executable=swmm_runner.__file__,
            model='SWMM',
            display_name='Running the SWMM model',
            run_weight=100,
            executable_is_script=True,
        )
        return [cmd]
