"""Entry point for spectral solution import."""

__copyright__ = "(C) Copyright Aquaveo 2021"
__license__ = "All rights reserved"

# 1. Standard Python modules
from typing import Optional

# 2. Third party modules

# 3. Aquaveo modules
from xms.api.dmi import Query, XmsEnvironment as XmEnv

# 4. Local modules
from xms.wavewatch3.file_io.spectral_solution_reader import WW3SpecSolutionReader


def main(query: Optional[Query] = None):  # pragma: no cover
    """Entry point wrapper."""
    try:
        reader = WW3SpecSolutionReader()
        reader.read()
    except Exception as ex:
        XmEnv.report_error(ex)


if __name__ == "__main__":  # pragma: no cover
    main()
