"""Presenter that creates a view-model of the Tools (menus and toolbars)."""
__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules


class ToolsPresenter:
    """A class to define the presenter of the Tools (menus and toolbars)."""
    def __init__(self):
        """Initialize the ToolsPresenter class."""
        self.menu_bar = {}
        self.tb_dict = {}
        self.center_toolbar_names = []

    def create_menu_bar(self, model_base, clipboard=None, sys_complexity=None):
        """Create the menu bar.

        Args:
            model_base (ModelBase): The model base instance.
            clipboard (Clipboard, optional): The clipboard instance. Defaults to None.
            sys_complexity (int, optional): The system complexity level. Defaults to None.
        """
        menu_dict = model_base.get_menu_dict(sys_complexity)
        if 'Project' in menu_dict:
            menu_dict.pop('Project')

        projects_list = model_base.get_projects_list()
        multiple_projects = len(projects_list) > 1

        if multiple_projects and 'File' in menu_dict and 'Save as' in menu_dict['File']:
            menu_dict['File']['Save as'].is_enabled = False
            menu_dict['File']['Save as'].tool_tip = 'Right-click on a project to specify save-as.'
        else:
            menu_dict['File']['Save as'].is_enabled = True
            menu_dict['File']['Save as'].tool_tip = 'Save the current project as a new file.'

        # Update paste menu item
        # clipboard = QApplication.clipboard()
        # Check if the clipboard has text
        # if clipboard is not None and clipboard.text() and 'Edit' in menu_dict and 'Paste' in menu_dict['Edit']:
        if clipboard is not None and 'Edit' in menu_dict and 'Paste' in menu_dict['Edit']:
            menu_dict['Edit']['Paste'].is_enabled = True
        else:
            menu_dict['Edit']['Paste'].is_enabled = False

        self.menu_bar = menu_dict
        return self.menu_bar

    def create_toolbars(self, model_base, sys_complexity=None):
        """Create the toolbars.

        Args:
            model_base (ModelBase): The model base instance.
            sys_complexity (int, optional): The system complexity level. Defaults to None.
        """
        tb_dict, center_toolbar_names = model_base.get_toolbar_dict(sys_complexity=sys_complexity)

        self.tb_dict = tb_dict
        self.center_toolbar_names = center_toolbar_names

        return self.tb_dict, self.center_toolbar_names

    # def create_context_menu(self, model_base):
    #     """Create the context menu."""
    #     return self.tools.create_toolbars(model_base)
