"""Generate info for about dialog."""
__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules
from dataclasses import dataclass
from pathlib import Path
from typing import Optional

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules


@dataclass
class CreditInfo:
    """Information about the developers."""
    name: str
    image: Optional[Path] = None
    description: Optional[str] = None


@dataclass
class DeveloperInfo:
    """Information about the developers."""
    name: str
    icon: Optional[Path] = None
    website: Optional[str] = None
    description: Optional[str] = None


@dataclass
class ApplicationInfo:
    """Information about the application."""
    app_name: str
    app_icon: str
    version: str
    build_message: str
    build_date: str
    website: Optional[str] = None
    wiki: Optional[str] = None
    description: str = ""


@dataclass
class SponsoringAgencyInfo:
    """Information about the sponsoring agency."""
    name: str
    icon: Optional[str] = None
    website: Optional[str] = None
    description: Optional[str] = None


@dataclass
class ModelInfo:
    """Information about a model."""
    model_name: str
    model_icon: Optional[str] = None
    version: Optional[str] = None
    sponsoring_agency: Optional[str] = None
    model_website: Optional[str] = None
    wiki_url: Optional[str] = None
    description: Optional[str] = None


@dataclass
class AboutDlgData:
    """Holds all the information needed to generate the help dialog."""
    application_info: ApplicationInfo
    sponsoring_agency_info: SponsoringAgencyInfo
    model_developer_info: DeveloperInfo
    interface_developer_info: DeveloperInfo
    credits: list[CreditInfo]
    included_models: list[ModelInfo]  # List of models included in the application
    available_models: list[ModelInfo]  # List of models available for purchase
