"""Reads the solution written by CMS-Flow."""

__copyright__ = "(C) Copyright Aquaveo 2024"
__license__ = "All rights reserved"

# 1. Standard Python modules
import os

# 2. Third party modules

# 3. Aquaveo modules
from xms.api.dmi import Query
from xms.components.display import windows_gui as win_gui
from xms.guipy.dialogs import xms_parent_dlg as xms_dlg

# 4. Local modules
from xms.cmsflow.feedback.read_solution_worker_thread import load_solution_file
from xms.cmsflow.feedback.xmlog import XmLog


def get_and_send_data():
    """Gets the solution data and sends to back to SMS."""
    xms_dlg.ensure_qapplication_exists()
    query = Query()
    h5_filename = query.read_file
    if not os.path.isfile(h5_filename):
        XmLog().instance.error(f'Solution file not found - {h5_filename}')
        return

    # Parse parent HWNDs from commandline arguments.
    parent_hwnd, main_hwnd, icon_path = xms_dlg.parse_parent_window_command_args()
    win_cont = xms_dlg.get_parent_window_container(parent_hwnd)
    # Create the timer that keeps our Python dialog in the foreground of XMS.
    _ = win_gui.create_and_connect_raise_timer(main_hwnd, win_cont)  # Keep the timer in scope

    file_name = os.path.basename(h5_filename)
    file_location = os.path.dirname(h5_filename)
    project_name = os.path.splitext(file_name)[0]
    load_solution_file(query, win_cont, file_location, project_name, None)
