from . import _xmsconstraint
from .grid import Grid
from .grid import GridType


class UnconstrainedGrid(Grid):
    """A unconstrained UGrid containing any type of cells."""
    def __init__(self, ugrid=None, instance=None):
        """Initializer for UGrid2d. Must be given either a UGrid or a C++ instance.

        Args:
            ugrid: An optional UGrid.
            instance: An optional C++ instance.
        """
        if ugrid:
            instance = _xmsconstraint.constraint.CoUnconstrainedGrid(ugrid._instance)
        if not instance:
            raise ValueError('Attempted to make a UnconstrainedGrid without a '
                             'ugrid or instance.')
        Grid.__init__(self, instance)

    @property
    def grid_type(self):
        """GridType of the constraint."""
        return GridType.unconstrained
