"""Qt table model using a pandas.DataFrame for storage."""
__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules
from PySide2.QtCore import QModelIndex, Qt

# 3. Aquaveo modules
from xms.guipy.models.qx_pandas_table_model import QxPandasTableModel

# 4. Local modules

NO_QMODELINDEX = QModelIndex()


class ComputationTableModel(QxPandasTableModel):
    """Override sorting methods for computation table."""
    def __init__(self, data_frame, parent=None):
        """Initializes the class.

        Args:
            data_frame (:obj:`pandas.DataFrame`): The pandas DataFrame.
            parent (Something derived from :obj:`QWidget`): The parent window.
        """
        super().__init__(data_frame, parent)

    def sort(self, column, order=None):
        """Sorts the model by column in the given order.

        Args:
            column (:obj:`int`): The column to sort.
            order (:obj:`QtCore.Qt.SortOrder`): The sort order.
        """
        colname = self.data_frame.columns.tolist()[column]
        self.layoutAboutToBeChanged.emit()
        self.data_frame.sort_values(colname, ascending=order != Qt.DescendingOrder, inplace=True, na_position='first')
        # self.data_frame.reset_index(inplace=True, drop=True)
        # self.data_frame.index += 1
        self.layoutChanged.emit()
