import os


def get_executable_paths():
    """Returns a list of executables in this folder."""
    paths = []
    for root, _, files in os.walk(os.path.dirname(__file__)):
        for file in files:
            if file.lower().endswith('.exe'):
                paths.append(os.path.normpath(os.path.join(root, file)))
    return paths


class _Paths:
    """Class for lazy-loading paths."""
    def __init__(self):
        """Initialize the class."""
        self.paths = {}

    def __getitem__(self, name: str):
        """
        The full path to a file name.
        
        Args:
            name: Name of the file to get, with extension. e.g. 'run_model.exe'.
        """
        if not self.paths:
            for path in get_executable_paths():
                file_name = os.path.basename(path)
                self.paths[file_name] = path
        return self.paths[name]


paths = _Paths()
