"""This is a table widget for specifying beach fill events."""

# 1. Standard Python modules
import datetime

# 2. Third party modules

# 3. Aquaveo modules
from xms.guipy.delegates.edit_field_validator import EditFieldValidator
from xms.guipy.models.rename_model import RenameModel
from xms.guipy.validators.qx_double_validator import QxDoubleValidator

# 4. Local modules
from xms.gencade.gui.gencade_table_widget import GenCadeTableWidget


class BeachFillTableWidget(GenCadeTableWidget):
    """Table widget base class."""
    def __init__(self, parent, data_frame):
        """Construct the widget.

        Args:
            parent (Something derived from :obj:`QObject`): The parent object.
            data_frame (:obj:`pandas.DataFrame`): The model data.

        """
        self.rename_model = None
        self.edit_delegate = None
        self.dbl_validator = None

        # set the first two columns to datetime64
        data_frame[data_frame.columns[0]] = data_frame[data_frame.columns[0]].astype(dtype='datetime64[ns]')
        data_frame[data_frame.columns[1]] = data_frame[data_frame.columns[1]].astype(dtype='datetime64[ns]')

        super().__init__(parent, data_frame, 0, {'start_date': [datetime.date(2000, 1, 1)],
                                                 'end_date': [datetime.date(2000, 1, 1)],
                                                 'added_berm_width': [0.0]})

    def setup_ui(self):
        """Sets up the delegates, validators, and filter model for this table."""
        self.rename_model = RenameModel(['Begin Date', 'End Date', 'Added Berm Width (ft or m)'], self)
        self.dbl_validator = QxDoubleValidator(parent=self)
        self.edit_delegate = EditFieldValidator(self.dbl_validator)
        delegates = {2: self.edit_delegate}
        super()._setup_ui(delegates, False, False, self.rename_model)
