"""This is a class for selecting a file and setting the resulting path text to a label."""

# 1. Standard Python modules
import os

# 2. Third party modules

# 3. Aquaveo modules
from xms.core.filesystem import filesystem as io_util
from xms.guipy.dialogs.file_selector_dialogs import get_open_filename
from xms.guipy.settings import get_file_browser_directory

# 4. Local modules


def find_file_selector_start_folder(filename):
    """Find a good place to start when popping up a file selector dialog.

    Args:
        filename (:obj:`str`): Path to the previously selected file or empty string if none

    Returns:
        (:obj:`str`): The directory to start the file selector in
    """
    if filename != '(none selected)' and filename:  # Start in the directory of the previously selected file
        file_path = io_util.resolve_relative_path(FileSelector.project_folder, filename)
        return os.path.dirname(file_path)
    else:  # Use priority defined in xmsguipy to get a default starting folder
        return get_file_browser_directory()


class FileSelector:
    """A class for selecting a file and setting a label to the file path."""
    project_folder = ''

    @staticmethod
    def select_file(parent, label_widget, caption, file_filter):
        """Brings up the file selector dialog.

        Args:
            parent (:obj:`QWidget`): The parent widget for the dialog.
            label_widget (:obj:`QLabel`): The label widget that stores the file path.
            caption (:obj:`str`): Some sort of caption.
            file_filter (:obj:`str`): The file types that can be selected.
        """
        file_path = label_widget.text()
        start_path = find_file_selector_start_folder(file_path)
        selected_file = get_open_filename(parent, caption, file_filter, start_dir=start_path)
        if selected_file:
            label_widget.setText(selected_file)
