"""GsshaSimData class."""

__copyright__ = '(C) Copyright Aquaveo 2024'
__license__ = 'All rights reserved'

# 1. Standard Python modules
from pathlib import Path

# 2. Third party modules

# 3. Aquaveo modules
from xms.gmi.data.sim_data import SimData

# 4. Local modules


class GsshaSimData(SimData):
    """Manages the data file for a simulation component."""
    GSSHA_DATA_VERSION = 'GSSHA_DATA_VERSION'  # To track changes to the generic model
    LATEST_VERSION = '0.0.3'  # The latest version

    def __init__(self, data_file: str | Path):
        """
        Initialize the data class.

        Args:
            data_file: The netcdf file (with path) associated with this instance data. Probably the owning
                       component's main file.
        """
        # _migrate() will be called by base class.
        super().__init__(data_file)

        # Always add the GSSHA_DATA_VERSION string, set to the latest version
        self.info.attrs[self.GSSHA_DATA_VERSION] = self.LATEST_VERSION
        self.commit()

    def _migrate(self):
        """Method to migrate data from different versions of the file."""
        pass  # We needed this to migrate test code and tutorials, but we don't support migrating while in beta
        # from packaging.version import parse
        # from xms.gssha.data import sim_generic_model
        # from xms.guipy.dialogs import message_box
        # migrated = False
        # version_str = self.info.attrs.get(self.GSSHA_DATA_VERSION, '0.0.0')
        # version = parse(version_str)
        # if version == parse('0.0.0'):
        #     gm = sim_generic_model.create(default_values=True)
        #     gm.global_parameters.restore_values(self.global_values)  # Restore old values into new model
        #     if gm.global_parameters.has_group('precipitation'):
        #         parameter = gm.global_parameters.group('precipitation').parameter('hyetograph_xy')
        #         val = parameter.value
        #         if not isinstance(val, int) and isinstance(val[1], int):
        #             parameter.value = val[1]  # This is the xy series ID
        #             self.global_values = gm.global_parameters.extract_values()
        #     version = parse('0.0.1')
        #     migrated = True
        # if version == parse('0.0.1'):
        #     # 'map_tables' was renamed to 'mapping_tables'
        #     if "'map_tables'" in self.model_values:
        #         self.model_values = self.model_values.replace("'map_tables'", "'mapping_tables'")
        #     version = parse('0.0.2')
        #     migrated = True
        # if version == parse('0.0.2'):
        #     # 'hyetograph_xy' changed from storing a curve ID to storing the curve itself
        #     gm = sim_generic_model.create(default_values=True)
        #     gm.global_parameters.restore_values(self.global_values)  # Restore old values into new model
        #     parameter = gm.global_parameters.group('precipitation').parameter('hyetograph_xy')
        #     val = parameter.value
        #     if isinstance(val, int):
        #         xs, ys = self.get_curve(val, use_dates=False)
        #         parameter.value = (list(xs), list(ys))
        #     self.global_values = gm.global_parameters.extract_values()
        #     version = parse('0.0.3')
        #     migrated = True
        #
        # assert version == parse(self.LATEST_VERSION)
        #
        # if migrated:
        #     msg = 'The simulation was migrated from a beta file format. Save the project to maintain support.'
        #     message_box.message_with_ok(None, msg, 'SMS')
