"""Creates the generic model for the Hydrograph coverage type."""

__copyright__ = '(C) Copyright Aquaveo 2024'
__license__ = 'All rights reserved'

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules
from xms.gmi.data.generic_model import GenericModel

# 4. Local modules


def create() -> GenericModel:
    """Creates and returns the generic model for the Hydrograph coverage type.

    Returns:
        (GenericModel): The generic model.
    """
    gm = GenericModel(exclusive_point_conditions=True, exclusive_arc_conditions=True)

    # Descriptions
    desc = {
        'name': 'Descriptive name for the hydrograph, up to 80 characters.',
        'map_to_boundary': 'Map arc to the boundary of the grid (not the interior).'
    }

    # Points
    group = gm.point_parameters.add_group(group_name='Hydrograph', label='Hydrograph')
    group.add_text(name='name', label='Name', default='hydrograph', description=desc['name'], required=True)

    # Arcs
    group = gm.arc_parameters.add_group(group_name='Hydrograph', label='Hydrograph')
    group.add_text(name='name', label='Name', default='hydrograph', description=desc['name'], required=True)
    group.add_boolean(
        'map_to_boundary', label='Map to grid boundary', default=False, description=desc['map_to_boundary']
    )
    return gm
