"""ObsMapAtt class."""

__copyright__ = '(C) Copyright Aquaveo 2024'
__license__ = 'All rights reserved'

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules
from xms.coverage.grid.ugrid_mapper import UgridMapper
from xms.gmi.data.generic_model import Group

# 4. Local modules
from xms.hgs.mapping.map_att import MapAtt


class ObsMapAtt(MapAtt):
    """A coverage attribute item (i.e. BC, observation,  hydrograph) with attributes and intersected grid components."""
    def __init__(self, feature, att_type: str, group: Group) -> None:
        """Initializes the class.

        Args:
            feature: A point, arc, or polygon.
            att_type (str): Attribute type (e.g. 'Flux nodal')
            group (Group): The BC as a generic model group.
        """
        super().__init__(feature, att_type, group)

    def intersect(self, ugrid_mapper: UgridMapper) -> None:
        """Intersects the feature object with the grid.

        Args:
            ugrid_mapper (UgridMapper | None): The UgridMapper for the 3D grid.
        """
        pass  # Don't need to do anything

    def write(self, section, *args, **kwargs) -> None:
        """Writes this MapAtt object to grok.

        Args:
            section (Type[SectionBase]): The section we are writing to.
        """
        if not self.value('interpolate', False):
            section.write_value('make observation point', self.value('name'))
        else:
            section.write_value('make interpolated observation point', self.value('name'))
        section.write_string(f'{self.feature.x} {self.feature.y} {self.feature.z}')
        section.write_string('')
