"""Code to read an Algomesh file."""

__copyright__ = '(C) Copyright Aquaveo 2024'
__license__ = 'All rights reserved'

# 1. Standard Python modules
from pathlib import Path

# 2. Third party modules
import numpy as np

# 3. Aquaveo modules

# 4. Local modules
from xms.hgs.file_io.binary_file_reader import BinaryFileReader


def read_algomesh_file(filepath: Path):
    """Reads the file.

    Args:
        filepath (Path): The filepath.

    Returns:
        (list[float]): The values
    """
    reader = BinaryFileReader(filepath, value_size=4, data_count=-1, nodata=1)
    _, values = reader.read()
    return np.where(values == 1.0)[0]
