"""GwfGweData class."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules
from typing_extensions import override

# 3. Aquaveo modules

# 4. Local modules
from xms.mf6.data.exchanges.exchange_data_base import ExchangeDataBase


class GwfGweData(ExchangeDataBase):
    """Data class to hold the info from a GWF-GWE exchange package file."""
    def __init__(self, **kwargs):
        """Initializes the class.

        Args:
            **kwargs: Arbitrary keyword arguments.

        Keyword Args:
            ftype (str): The file type used in the GWF name file (e.g. 'WEL6')
            mfsim (MfsimData): The simulation.
            model: The model. Will be None for TDIS, IMS, Exchanges (things below mfsim).
            grid_info (GridInfo): Information about the grid. Only used when testing individual packages. Otherwise,
             it comes from model and dis.
        """
        super().__init__(**kwargs)
        self.ftype = 'GWF6-GWE6'

    @override
    def dialog_title(self):
        """Returns the title to show in the dialog.

        You should override this method.

        Returns:
            (str): The dialog title.
        """
        return 'GWF-GWE Exchange'
