"""EmsWriter class."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.mf6.file_io.package_writer_base import PackageWriterBase


class EmsWriter(PackageWriterBase):
    """Writes an EMS package file.

    "The current input file for EMS has no options or input; however an empty input file is required if EMS is
    required for particle tracking."
    """
    def __init__(self):
        """Initializes the class."""
        super().__init__()

    def _write_package(self, data):
        """Writes the package file.

        Args:
            data (xms.mf6.ims_package_data.ImsData): The data.
        """
        with open(self._data.filename, 'w'):
            pass
