"""MvrReader class."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.mf6.file_io import database
from xms.mf6.file_io.package_reader import PackageReader


class MvrReader(PackageReader):
    """Reads a MVR package file."""
    def __init__(self):
        """Initializes the class."""
        super().__init__(ftype='MVR6')
        self._block_methods = {'PACKAGES': '_handle_list_block'}

    # def _read_connectiondata(self, line):
    #     # TODO: Read MVR CONNECTIONDATA
    #     pass

    def _read_dimensions(self, line):
        """Reads the dimensions block.

        Args:
            line (str): line from file
        """
        words = line.split()
        if not words:
            self.invalid_line_in_file(line)
            return

        if words[0].upper() == 'MAXPACKAGES' and len(words) > 1:
            self._data.maxpackages = int(words[1])

        # Set the periods.db filename if one exists
        database.set_periods_db_filename(self._data)
