"""StoReader class."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.mf6.file_io.package_reader import PackageReader


class StoReader(PackageReader):
    """Reads a STO package file."""
    def __init__(self):
        """Initializes the class."""
        super().__init__(ftype='STO6')

    def _read_period(self, line):
        """Reads the stress period.

        Args:
            line (str): A line from the file.
        """
        words = line.split()
        if words and len(words) > 0:
            if words[0].upper() == 'STEADY-STATE':
                self._data.stress_periods[self._curr_block_number] = 1
            elif words[0].upper() == 'TRANSIENT':
                self._data.stress_periods[self._curr_block_number] = 0
