"""StoWriter class."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.mf6.file_io import io_util
from xms.mf6.file_io.package_writer_base import PackageWriterBase


class StoWriter(PackageWriterBase):
    """Writes the package to disk."""
    def __init__(self):
        """Initializes the class."""
        super().__init__()
        self._fp = None

    def _write_periods(self):
        for sp, ss_or_tr in self._data.stress_periods.items():
            self._fp.write('\n')
            self._fp.write(f'BEGIN PERIOD {sp}\n')
            word = 'STEADY-STATE' if ss_or_tr else 'TRANSIENT'
            self._fp.write(f'{io_util.mftab}{word}\n')
            self._fp.write('END PERIOD\n')

    def _write_package(self, data):
        """Writes the package data to disk.

        Args:
            data (StoData): The package data.
        """
        self._data = data
        with open(data.filename, 'w') as self._fp:
            self._write_comments(self._fp)
            self._write_options(self._fp)
            self._write_griddata(self._fp)
            self._write_periods()
