"""sqlite queries."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules
import sqlite3

# 2. Third party modules
from xms.testing.type_aliases import Pathlike

# 3. Aquaveo modules

# 4. Local modules


def locked_status(dynamic_db_filepath: Pathlike, comp_uuid: str) -> bool:
    """Return the locked status of the component.

    Args:
        dynamic_db_filepath:
        comp_uuid: Uuid of the component.

    Returns:
        See description.
    """
    try:
        with sqlite3.connect(dynamic_db_filepath) as cxn:
            cur = cxn.cursor()
            stmt = 'SELECT Locked from Components WHERE Uuid == ?'
            cur.execute(stmt, (comp_uuid, ))
            rv = cur.fetchall()
            return rv[0][0]
    except sqlite3.Error as er:  # pragma no cover
        print(str(er))
        raise er
