"""Script to launch srh pest post."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules

if __name__ == '__main__':
    import argparse
    from xms.srh.model.srh_pest_final_run import run_pest_final_run

    parser = argparse.ArgumentParser(description="SRH post.")
    parser.add_argument('-f', '--hydro-file', help='SRH-2D HYDRO file path and filename', required=True, default='')
    parser.add_argument(
        '-m', '--main-file', help='Simulation component main file path and filename', required=True, default=''
    )
    args = parser.parse_args()

    if args.hydro_file and args.main_file:
        run_pest_final_run(args.hydro_file, args.main_file)
