"""ContoursFromSingleRasterValueWhiteboxTool whitebox tool class."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.tool.whitebox import WhiteboxTool
from xms.tool.whitebox.whitebox_tool import get_argument_from_name


class ContoursFromSingleRasterValueWhiteboxTool(WhiteboxTool):
    """ContoursFromSingleRasterValueWhiteboxTool whitebox tool class."""

    def __init__(self):
        """Initializes the class."""
        super().__init__('ContoursFromRaster', 'Contours from Single Raster Value',
                         ignored_arg_values={'contour_interval': 1.0e100},
                         arg_descriptions={'output_contour_file': 'Output contour coverage'})

    def validate_arguments(self, arguments):
        """Called to determine if arguments are valid.

        Args:
            arguments (list): The tool arguments.

        Returns:
            (dict): Dictionary of errors for arguments.
        """
        errors = {}
        raster = self.get_input_raster(get_argument_from_name(arguments, 'input_raster_surface_file').value)
        z_min, z_max = raster.get_z_min_max()
        base_value = get_argument_from_name(arguments, 'base_contour').value
        if not z_min < base_value < z_max:
            errors['base_contour'] = 'The base contour elevation needs to be set to a value within the range of ' \
                                     f'elevations for the raster. {base_value} is not within the range of the raster ' \
                                     'elevations.'
        return errors
