"""Classes to Define the model-view of a select file."""
__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules
from dataclasses import dataclass, field
import uuid

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules


@dataclass
class SelectFile():
    """Select a file."""

    def __init__(self, select_uuid: str = None):
        """Initialize the select file class."""
        self.uuid = select_uuid
        if self.uuid is None:
            self.uuid = uuid.uuid4()

        self.parent = None
        self.window_title: str = ""
        self.starting_path: str = ""
        # example of file filter: ["Hydraulic Toolbox Files (*.htb)", "All Files (*)"]
        self.file_types: list[str] = field(default_factory=list)
        # file mode ('folder', 'existing file', 'new file', 'any')
        self.file_mode: str = 'existing file'
        self.allow_multiple_files: bool = False
        # accept mode ('accept open', 'accept save')
        self.accept_mode: str = 'accept open'
