"""Classes to Define the model-view of the main interface."""
__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules
from dataclasses import dataclass, field
from uuid import UUID, uuid4

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
# from xms.FhwaVariable.core_data.calculator.tree_data import TreeData
# from xms.FhwaVariable.core_data.calculator.metadata import Metadata


@dataclass
class SupportWindow:
    """A class to define the model-view of the main interface."""
    app_uuid: UUID | None = None
    window_index: int = 0
    app_title: str = ''
    icon: str = ''
    status_message: str = ''
    maximized: bool = False
    minimized: bool = False
    x: int = 100
    y: int = 100
    width: int = 800
    height: int = 600
    windows: dict = field(default_factory=dict)
    show_dialog_plots: bool = False
    plot_dock_area: str = 'left'
    plots_dict: dict = field(default_factory=dict)
    show_wiki: bool = True
    wiki_dock_area: str = 'right'
    use_only_this_wiki: bool = False
    use_only_this_wiki_enabled: bool = False
    wiki_start_url: str = "https://www.xmswiki.com/wiki/Main_Page"
    wiki_url: str = ""

    # Computed fields
    uuid: UUID = field(init=False)
    support_window_index: int = field(init=False)
    window_title: str = field(init=False)

    def __post_init__(self):
        """Initialize computed fields after dataclass initialization."""
        self.uuid = self.app_uuid if self.app_uuid is not None else uuid4()
        self.support_window_index = self.window_index
        self.window_title = f'{self.app_title} - Support Window {self.window_index + 1}'

        # Screen, screen size, and screen position
        # screen = None

        # TODO: Consider adding options to dock windows from main window

        # self.title_bg_color = (0, 0, 0)
        # self.title_text_color = (255, 255, 255)
        # self.bg_color = (0, 0, 0)
        # self.text_color = (255, 255, 255)
        # self.selected_bg_color = None
        # self.selected_text_color = None
        # self.hover_bg_color = None
        # self.hover_text_color = None
        # self.item_bg_color = (0, 0, 0)
        # self.item_text_color = (255, 255, 255)
        # self.doc_bg_color = (0, 0, 0)
