"""Entry point to export fort15 file."""

# 1. Standard Python modules
import os

# 2. Third party modules
from xms.api.dmi import XmsEnvironment as XmEnv

# 3. Aquaveo modules

# 4. Local modules
from xms.adcirc.feedback.fort15_worker_thread import export_fort15_with_feedback
from xms.adcirc.feedback.xmlog import XmLog


def main():
    """Entry point wrapper."""
    try:
        export_fort15_with_feedback(
            filename=os.path.join(os.getcwd(), 'fort.15'), query=None, xms_data=None, note='', parent=None
        )
    except Exception as ex:
        msg = 'Error(s) encountered while exporting ADCIRC simulation.'
        XmLog().instance.exception(msg)
        XmEnv.report_error(msg)
        XmEnv.report_error(ex)


if __name__ == "__main__":
    main()
