"""This module loads an AdH solution to XMS."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.adh.file_io.load_solution import get_and_send_data

if __name__ == "__main__":  # pragma: no cover
    try:
        get_and_send_data()
    except Exception as ex:
        import os
        import traceback
        with open(f'adh_solution_import_{os.getpid()}.log', 'a') as file:
            traceback.print_exception(type(ex), ex, ex.__traceback__, file=file)
        raise ex  # Let XMS know we failed until we implement better feedback mechanism
