"""Display handling."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules
import os
import uuid

# 2. Third party modules

# 3. Aquaveo modules
from xms.components.display.display_options_io import read_display_options_from_json, write_display_options_to_json
from xms.guipy.data.category_display_option_list import CategoryDisplayOptionList

# 4. Local modules

# ID file names used for display
BC_ARC_INITIAL_ATT_ID_FILE = 'initial_arc_bc.attids'
BC_ARC_INITIAL_COMP_ID_FILE = 'initial_arc_bc.compids'
BC_POINT_INITIAL_ATT_ID_FILE = 'initial_pt_bc.attids'
BC_POINT_INITIAL_COMP_ID_FILE = 'initial_pt_bc.compids'
MAT_INITIAL_ATT_ID_FILE = 'initial_mat.attids'
MAT_INITIAL_COMP_ID_FILE = 'initial_mat.compids'
SED_MAT_INITIAL_ATT_ID_FILE = 'initial_sed_mat.attids'
SED_MAT_INITIAL_COMP_ID_FILE = 'initial_sed_mat.compids'


def fix_duplicated_display_opts(new_path, disp_opts_fname) -> dict:
    """Fixes UUIDs in duplicated display options.

    Args:
        new_path (:obj:`str`): Path to the new save location.
        disp_opts_fname (:obj:`str`): The filename (no path) of the display options JSON file

    Returns:
        (:obj:`json_dict`): dict containing the display options

    """
    fname = os.path.join(new_path, disp_opts_fname)
    json_dict = read_display_options_from_json(fname)
    if 'uuid' in json_dict:
        json_dict['uuid'] = str(uuid.uuid4())
        json_dict['comp_uuid'] = os.path.basename(new_path)
        categories = CategoryDisplayOptionList()  # Generates a random UUID key for the display list
        categories.from_dict(json_dict)
        write_display_options_to_json(fname, categories)
    return json_dict
