"""Python wrapping for xms.api._xmsapi.dmi.GetDataRequest."""
# 1. Standard python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.api._xmsapi.dmi import GetDataResult as CGetDataResult
from xms.api.dmi.ResultBase import ResultBase


class GetDataResult(ResultBase):
    """The pure Python wrapper for C++ exposed xms.api._xmsapi.dmi.GetDataResult objects."""
    def __init__(self, instance=None):
        """Construct the wrapper.

        Note that this is a low-level API object that should not be constructed directly.

        Args:
            instance (xms.api._xmsapi.dmi.GetDataResult): The C++ object to wrap
        """
        if instance is None:
            instance = CGetDataResult()
        super().__init__(instance)

    def __getitem__(self, item):
        """Dict-like interface for retrieving result data."""
        return self._instance.__getitem__(item)

    @property
    def parameters(self):
        """Returns the dict of the GetDataResult data."""
        return self._instance.GetParameters()

    @parameters.setter
    def parameters(self, params):
        """Sets the dict of the GetDataResult data.

        Args:
            params (dict): The GetDataResult data
        """
        self._instance.SetParameters(params)
