"""Python wrapping for xms.api._xmsapi.dmi.Menu."""
# 1. Standard python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.api._xmsapi.dmi import Menu as CMenu


class Menu:
    """The pure Python wrapper for C++ exposed xms.api._xmsapi.dmi.Menu objects."""
    def __init__(self, text=None, icon_path=None, instance=None):
        """Construct the wrapper.

        Args:
            text (str): The menu text that will appear in the right-click menu of the parent object
            icon_path (str): Path to the menu item's icon image. Must be an image that can be imported into the Qt
                GUI environment.
            instance (CMenu): The C++ Menu object to wrap
        """
        if instance is None:
            self._instance = CMenu()
        else:
            self._instance = instance

        if text is not None:
            self._instance.SetText(text)
        if icon_path is not None:
            self._instance.SetIcon(icon_path)

    @property
    def icon(self):
        """Returns the filesystem path to the icon file associated with the menu."""
        return self._instance.GetIcon()

    @icon.setter
    def icon(self, icon_path):
        """Sets the filesystem path to the icon file associated with the menu.

        Args:
            icon_path (str): Path to the menu's icon image. Must be an image that can be imported into the Qt
                GUI environment.
        """
        self._instance.SetIcon(icon_path)

    @property
    def text(self):
        """Returns the GUI text that appears with this menu."""
        return self._instance.GetText()

    @text.setter
    def text(self, menu_text):
        """Sets the GUI text that appears with this menu.

        Args:
            menu_text (str): The menu text that will appear in the right-click menu of the parent object
        """
        self._instance.SetText(menu_text)

    def add_menu(self, menu):
        """Adds a submenu command to the parent menu folder.

        Args:
            menu (xms.api.dmi.Menu): The fly-out submenu to add
        """
        self._instance.AddMenu(menu._instance)

    def add_menu_item(self, item):
        """Adds a menu command to the parent menu folder.

        Args:
            item (xms.api.dmi.MenuItem): The right-click menu item to add
        """
        self._instance.AddMenuItem(item._instance)

    def add_separator(self):
        """Adds a separator between previously added MenuItem objects and subsequent items."""
        self._instance.AddSeparator()
