"""SimComponent class."""
# 1. Standard python modules

# 2. Third party modules

# 3. Aquaveo modules

# 4. Local modules
from xms.cstorm.components.base_component import BaseComponent
from xms.cstorm.data.sim_data import SimData
from xms.cstorm.gui.model_control import model_control_dialog

__copyright__ = "(C) Copyright Aquaveo 2023"
__license__ = "All rights reserved"


class SimComponent(BaseComponent):
    """A hidden Dynamic Model Interface (DMI) component for the RSM model simulation."""
    def __init__(self, main_file):
        """Initializes the component class.

        Args:
            main_file: The main file associated with this component.
        """
        super().__init__(main_file)

        self.data = SimData(self.main_file)
        self.tree_commands = [
            ('Model Control...', 'open_model_control'),
        ]  # [(menu_text, menu_method)...]

    def open_model_control(self, query, params, win_cont):
        """Opens the Model Control dialog and saves component data state on OK.

        Args:
            query (:obj:`Query`): Object for communicating with XMS
            params (:obj:`list[dict]`): Generic map of parameters. Contains selection map and component id files.
            win_cont (:obj:`QWidget`): The window container.

        Returns:
            (:obj:`tuple(list, list)`), (:obj:`list[ActionRequest]`):
                messages (:obj:`list[tuple(str, str)]`): List of tuples with the first element of the tuple being the
                message

                level ('DEBUG', 'ERROR', 'WARNING', 'INFO') and the second element being the message text.

                action_requests (:obj:`list[ActionRequest]`): List of actions for XMS to perform.
        """
        model_control_dialog(self, query, win_cont)
        return [], []
