"""Helper methods for operating on numpy arrays."""

# 1. Standard Python modules
from typing import Sequence

# 2. Third party modules
import numpy as np

# 3. Aquaveo modules

# 4. Local modules


def ensure_sequence_is_numpy_array(sequence: Sequence) -> np.ndarray:
    """Convert a list-like sequence into a numpy array if it is not already.

    Args:
        sequence (:obj:`Sequence`): The list-like values (e.g. list, tuple)

    Returns:
        (:obj:`numpy.ndarray`): The sequence as a numpy ndarray
    """
    if not isinstance(sequence, np.ndarray):
        sequence = np.array(sequence)
    return sequence
