"""Base class Python wrapper for snappers."""
# 1. Standard python modules

# 2. Third party modules

# 3. Aquaveo modules
from xms.constraint import read_grid_from_file

# 4. Local modules
from xms.snap._xmssnap.snap import _SnapBase


class SnapBase(_SnapBase):

    def __init__(self):
        """Constructor."""
        _SnapBase.__init__(self)

    def set_grid(self, grid, target_cells):
        """Sets the geometry that will be snapped to."""
        pass

    def get_co_grid(self, grid):
        """Creates the CoGrid and populates it with points and cells.

        Args:
            grid (xms.data_objects.parameters.UGrid): The grid that will be coverted. This should be one of the
                old H5 dump impls (only available through C++ wrappings).

        Returns:
            UGrid2d
        """
        cogrid_file = grid.cogrid_file
        return read_grid_from_file(cogrid_file)
