"""BcDataGate class."""

__copyright__ = "(C) Copyright Aquaveo 2025"
__license__ = "All rights reserved"

# 1. Standard Python modules

# 2. Third party modules
import param

# 3. Aquaveo modules
from xms.guipy.param.param_enabler import ParamEnabler  # noqa: I202

# 4. Local modules
from xms.srh.data.par.bc_data_weir_type import BcDataWeirType


class BcDataGate(param.Parameterized):
    """Bc type gate data."""
    units = param.ObjectSelector(
        default='Feet',
        objects=['Feet', 'Meters'],
        doc='',
        precedence=1,
    )
    crest_elevation = param.Number(
        default=0.0,
        doc='',
        precedence=2,
    )
    height = param.Number(
        label='Height of gate opening',
        default=0.0,
        doc='',
        precedence=3,
    )
    width = param.Number(
        label='Width of gate opening',
        default=0.0,
        doc='',
        precedence=4,
    )
    contract_coefficient = param.Number(
        label='Contract coefficient with underflow orifice',
        default=0.6,
        doc='',
        precedence=5,
    )
    type = param.ClassSelector(
        label='',
        class_=BcDataWeirType,
        doc='',
        precedence=6,
    )

    def __init__(self):
        """Initializes the class."""
        super().__init__()
        self.type = BcDataWeirType()
        self.enabler = ParamEnabler(
            param_cls=self,
            enablers=[],
            depends={},
        )
