"""ModelControlAdvanced class."""
# 1. Standard python modules
from datetime import datetime

# 2. Third party modules
import param

# 3. Aquaveo modules

# 4. Local modules

__copyright__ = "(C) Copyright Aquaveo 2022"
__license__ = "All rights reserved"


class ModelControlWatershed(param.Parameterized):
    """Manages data file for the hidden simulation component."""
    select_landuse_raster = param.Action(
        doc='Selector for the land use raster.',
        label='Select Land Use Raster...',
        precedence=1,
    )
    landuse_raster_string = param.String(
        label='',
        default='No land use raster selected',
        doc='Land use raster from xms',
        precedence=1.1,
    )
    select_soil_shapefile = param.Action(
        doc='Selector for the soil shapefile.',
        label='Select Soil Type Shapefile...',
        precedence=2,
    )
    soil_shapefile_string = param.String(
        label='',
        default='No soil shapefile selected',
        doc='Soil shapefile from xms',
        precedence=2.1,
    )
    select_stream_coverage = param.Action(
        doc='Selector for the stream coverage.',
        label='Select Stream Coverage...',
        precedence=3,
    )
    stream_coverage_string = param.String(
        label='',
        default='No stream coverage selected',
        doc='Stream coverage from xms',
        precedence=3.1,
    )
    channel_manning = param.Number(
        doc="Channel Manning's roughness value.",
        label="Channel Manning's roughness",
        default=0.03,
        precedence=3.5,
    )
    overland_manning = param.Number(
        doc="Overland Manning's roughness value.",
        label="Overland Manning's roughness",
        default=0.1,
        precedence=3.6,
    )
    land_use_table_button = param.Action(
        doc='Define the land use table.',
        label='Land Use Table...',
        precedence=4,
    )
    soil_type_table_button = param.Action(
        doc='Define the soil type table.',
        label='Soil Type Table...',
        precedence=5,
    )
    start_date_time = param.String(
        default=datetime.now().strftime('%Y-%m-%d %H:%M'),
        label='Starting date and time (format: YYYY-MM-DD HH:MM)',
        doc='Define the starting date and time (format: YYYY-MM-DD HH:MM).',
        precedence=6,
    )
    select_bedrock_dataset = param.Action(
        doc='Selector for the bedrock dataset.',
        label='Select Bedrock Dataset...',
        precedence=7,
    )
    bedrock_dataset = param.String(
        label='',
        default='No Dataset selected',
        doc='UUID of dataset selected from xms',  # Time step number (1-based) may be appended with a colon ('uuid:ts')
        precedence=7.5,
    )
    select_unsat_dataset = param.Action(
        doc='Selector for the unsaturated soil depth dataset.',
        label='Select Unsaturated Soil Depth Dataset...',
        precedence=8,
    )
    unsat_dataset = param.String(
        label='',
        default='No Dataset selected',
        doc='UUID of dataset selected from xms',  # Time step number (1-based) may be appended with a colon ('uuid:ts')
        precedence=8.5,
    )
    select_sat_dataset = param.Action(
        doc='Selector for the saturated soil depth dataset.',
        label='Select Saturated Soil Depth Dataset...',
        precedence=9,
    )
    sat_dataset = param.String(
        label='',
        default='No Dataset selected',
        doc='UUID of dataset selected from xms',  # Time step number (1-based) may be appended with a colon ('uuid:ts')
        precedence=9.5,
    )
    select_init_soil_temp_dataset = param.Action(
        doc='Selector for the initial soil temperature dataset.',
        label='Select Initial Soil Temperature Dataset...',
        precedence=10,
    )
    init_soil_temp_dataset = param.String(
        label='',
        default='No Dataset selected',
        doc='UUID of dataset selected from xms',  # Time step number (1-based) may be appended with a colon ('uuid:ts')
        precedence=10.5,
    )

    def __init__(self):
        """Initializes the data class."""
        super().__init__()
        self.landuse_raster_string = 'No land use raster selected'
        self.bedrock_dataset = 'No Dataset selected'
