"""RainfallPoint class."""
# 1. Standard python modules

# 2. Third party modules
import param

# 3. Aquaveo modules
from xms.guipy.param.param_enabler import ParamEnabler  # noqa: I202

# 4. Local modules

__copyright__ = "(C) Copyright Aquaveo 2022"
__license__ = "All rights reserved"


class RainfallPoint(param.Parameterized):
    """Data for rainfall points."""
    rainfall_point = param.Boolean(
        label='Measured value',
        default=False,
        doc='Check box to give rainfall value to point.',
        precedence=1,
    )
    rainfall_value = param.Number(
        default=0.0,
        doc='Measured rainfall value.',
        precedence=2,
    )

    def __init__(self):
        """Initializes the class."""
        super().__init__()
        self.enabler = ParamEnabler(
            param_cls=self,
            enablers=['rainfall_point'],
            depends={
                'rainfall_point': ['rainfall_value']
            },
        )

    @param.depends('rainfall_point', watch=True)
    def _update_rainfall_point(self):
        self.enabler.do_enabling(force_disable=False)
