"""Script to launch srh post."""
if __name__ == '__main__':
    import argparse
    from contextlib import redirect_stdout
    from xms.api.dmi import XmsEnvironment as XmEnv
    from xms.srh.model.srh_post_runner import run_post_process

    parser = argparse.ArgumentParser(description="SRH post.")
    parser.add_argument('-j', '--json-file', help='Path to srh_post.json', required=False, default='')
    args = parser.parse_args()

    log_file = XmEnv.xms_environ_stdout_file()
    with open(log_file, 'a') as stdout:
        with redirect_stdout(stdout):
            if args.json_file:
                run_post_process(args.json_file)
            else:
                run_post_process()
