"""Worker thread for the control file exporter."""

# 1. Standard Python modules
import logging

# 2. Third party modules

# 3. Aquaveo modules
from xms.guipy.dialogs.process_feedback_dlg import ProcessFeedbackThread

# 4. Local modules
from xms.stwave.file_io.sim_writer import SimWriter
from xms.stwave.gui.gui_util import logging_filename


class SimExportWorkerThread(ProcessFeedbackThread):
    """Worker thread for exporting an STWAVE control file."""

    def __init__(self, filename, query, parent):
        """Construct the worker.

        Args:
            filename (str): Path to the export location.
            query (xms.api.dmi.Query): Object for communicating with XMS
            parent (QWidget): Parent of the QThread
        """
        super().__init__(parent=parent, do_work=self._do_work)
        self._filename = filename
        self._query = query
        self._logger = logging.getLogger('xms.stwave')

    def _do_work(self):
        """Thread runner that exports the .sim control file."""
        self._logger.info('Exporting STWAVE control file...')
        try:
            sim_writer = SimWriter(query=self._query, filename=self._filename)
            sim_writer.write()
            self._logger.info(f'Successfully exported STWAVE control file to "{logging_filename(self._filename)}".')
        except Exception:
            self._logger.exception('Error! Could not export STWAVE control file.')
